% Code that calculates the steady state equilibrium in the 
% Aiyagari McGrattan 1998 model in continuous time with proportional 
% taxes and inelastic labor supply.

% Based on codes from Ben Moll, optimized for speed by SeHyoun Ahn
% See:
% http://www.princeton.edu/~moll/HACTproject/HACT_Numerical_Appendix.pdf
% for detailed explanations of the algorithm.
%
% The key experiment performed with this model is changing the government
% policy, specifically raising debt/GDP ratio.
%
% Author: Lukasz Rachel    Date: 26 June 2018

clear all;
clc; close all;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%           1. SETUP           %%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% HH inverse IES
ggammas = [3,2,3/2];    


% Government
gov_g = 0.2;%0.2;  % G/Y: government consumption as a share of GDP
gov_b = 0.9;%0.3;  % B/Y: government debt / GDP ratio
gov_tr= 0;%0.12; % TR/Y: government lump sum transfers / GDP ratio

% Uncertainty & inequality
p = [0.939  0.04  0.02  0.001;...
     0.034 0.816 0.140 0.01;...
     0.001 0.080 0.908 0.011;...
     0.1   0.015 0.06  0.825];
z_lo = [0.2, 0.55, 0.8, 4.351];
z_hi = [0.2, 0.55, 0.8, 6.116];


r_1 = zeros(1,3);
r_2 = zeros(1,3);
r_3 = zeros(1,3);
%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%        2. SOLVE MODEL           %%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Loop over IES and gov debt

for i = 1:numel(ggammas)
    disp('Gamma number:')
    disp(i)
ggamma = ggammas(i);
disp('model 1')
r_1(1,i) = solve_model(ggamma, gov_g, 0.3, gov_tr, p, z_lo);
disp('model 2')
r_2(1,i) = solve_model(ggamma, gov_g, 0.9, gov_tr, p, z_lo);
disp('model 3')
r_3(1,i) = solve_model(ggamma, gov_g, 0.9, gov_tr, p, z_hi);
end 

% calculate the changes to the interest rate which can then be copied to
% Excel (Robustness sheet)

impacts = [r_3 - r_2; r_2 - r_1]*100;




